 ; VBM - middle rejustify a column of text.
 ; Copyright 1995, 2006, 2008 by Rocket Software Ltd.
 ; 
 (DEFUN C:VBM (/ ss cc rr xa num enam entt typ pty pa sp)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (prompt "Pick text/attdefs to middle rejustify: ")
  (if (setq ss (ssget '((-4 . "<or")
                        (0 . "text")
                        (0 . "attdef")
                        (-4 . "or>"))))
      (progn
           (setq xa (getpoint "Pick one side: "))
           (setq rr (getpoint xa "\n...and the other side or <Return>:"))
           (if rr 
              (setq xa (list (/ (+ (car xa) (car rr)) 2)
                             (/ (+ (cadr xa) (cadr rr)) 2)
                             (/ (+ (caddr xa) (caddr rr)) 2))))
 ; Use the text angle of the first text entity as the angle for all of them.
           (setq entt (entget (ssname ss 0)))
           (setq txang (cdr (assoc 50 entt)))
           (if (null (setq obliq (cdr (assoc 51 entt))))
               (setq obliq 0))
           (setq dnang (- txang (/ pi 2) obliq))
           (setq xb (polar xa dnang 100))
 ; For each entity, find its angle and the intersection of its baseline with
 ; a line from xa at dnang, the text down angle.
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq entt (entget enam))            ; get changed edata
 ; Make it middle justified.
                  (setq ten (cdr (assoc 10 entt)))     ; save 10 point
                  (setq typ (cdr (assoc 0 entt)))      ; entity type
                  (if (= typ "ATTDEF")
                      (setq entt (subst (cons 74 0) (assoc 74 entt) entt))
                      (setq entt (subst (cons 73 0) (assoc 73 entt) entt)))
                  (entmod (subst (cons 72 4) (assoc 72 entt) entt))  ; change
                  (setq entt (entget enam))            ; get changed edata
                  (setq new10 (cdr (assoc 10 entt)))   ; new 10 point
                  (setq dist (distance ten new10))     ; distance moved
                  (setq angl (angle new10 ten))        ; and angle
                  (setq new11 (cdr (assoc 11 entt)))   ; new middle point
                  (setq new11 (polar new11 angl dist)) ; move middle as 10 was
                  (entmod (subst (cons 11 new11) (assoc 11 entt) entt))
                  (setq entt (entget enam))            ; get entity data
                  (setq txang (cdr (assoc 50 entt)))
                  (setq txpa (cdr (assoc 11 entt)))
                  (setq txpb (polar txpa txang 100))
                  (setq pa (inters xa xb txpa txpb nil))
                  (entmod (subst (cons 11 pa) (assoc 11 entt) entt)))
 ; Sum up and end.
           (setq sp (if (= (setq num (sslength ss)) 1) "" "s"))
           (prompt (strcat "\n" (itoa num) " line" sp " middle rejustified.")))
      (prompt "\nNo text selected."))
  (command ".undo" "end")
 (princ))